// I2CBus.h: interface for the I2CBus class.
//
// code ported from the visual basic source code of the program 
// "I2CTools" and "ServoCtr" by OOPic.
// Alex Barth Dec. 2002
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_I2CBUS_H__F8412A80_DB68_423E_B7F6_C4BC4AFC66B8__INCLUDED_)
#define AFX_I2CBUS_H__F8412A80_DB68_423E_B7F6_C4BC4AFC66B8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define CI2CACK			0
#define CI2CNACK		1
#define CI2CCABLEERROR	2

class I2CBus  
{
public:
	I2CBus();
	virtual ~I2CBus();

	bool I2CSendStart();
	void I2CSendStop();
	void I2CSendAck();
	void I2CSendNAck();
	void I2CFlushBitStream();
	BYTE I2CReadByte();
	void I2CSendByte( BYTE ByteToSend, BYTE* Ack );
	void I2CSendByte( BYTE ByteToSend );
	void I2CSendAddressW(BYTE I2CAddress, BYTE* Ack);
	void I2CSendAddressR(BYTE I2CAddress, BYTE* Ack);
	void I2CSetClockLine(BYTE LogicLevel);
	bool I2CReadClock();
	void I2CSetDataLine( BYTE LogicLevel );
	bool I2CReadData();
	void I2CSetReset(BYTE LogicLevel);
	void I2CDelay();
	void I2CGetLastMessage(char* msg);

private:
	BYTE PortInp(int zPortAddress);
	void PortOut(int zPortAddress, BYTE zValue);
	void ResolveLPTPort(int PortAddress);
	char* LPTPortAddress(int xPort);
	void ClockGroundedMessage();
	void ClockNotGroundedMessage();
	void DataNotGroundedMessage();
	void NackMessage();
	
	int  cResetPort;
	BYTE cResetHigh;
	BYTE cResetLow;
	int  cClockOutPort;
	BYTE cSCLoHigh;
	BYTE cSCLoLow;
	int  cDataOutPort;
	BYTE cSDAoHigh;
	BYTE cSDAoLow;
	int  cClockInPort;
	BYTE cSCLMask;
	BYTE cSCLiLow;
	BYTE cSCLiHigh;
	int  cDataInPort;
	BYTE cSDAMask;
	BYTE cSDAiLow;
	BYTE cSDAiHigh;
	bool Ack;
	long int gDelayTime;

	char* m_szLastMessage;

};

#endif // !defined(AFX_I2CBUS_H__F8412A80_DB68_423E_B7F6_C4BC4AFC66B8__INCLUDED_)
