// OOPic.cpp: implementation of the OOPic class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "OOPic.h"
#include <stdio.h>

#define OOPIC_ADDRESS  0

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

OOPic::OOPic()
{
	m_bOOPicNode = 2;			// address of OOPic
	m_pOOPicNet = new OOPicNet();
}

OOPic::~OOPic()
{
	delete m_pOOPicNet;
}

// write byte val to specified address addr in OOPic
//
bool OOPic::Write(BYTE addr, BYTE val)
{
	char btbuffer[256];
	sprintf(btbuffer, "%c", val);
	m_pOOPicNet->WriteMemoryToOOPic(m_bOOPicNode, addr, btbuffer, 0, true);
	return true;
}

// read single byte from OOPic at specified addr
//
BYTE OOPic::ReadByte(BYTE addr)
{
	char btbuffer[2];
	char c;
	m_pOOPicNet->ReadMemoryFromOOPic(m_bOOPicNode, addr, btbuffer, 1, true);	
	strncpy(&c, btbuffer, 1);
	return c;
}


