// OOPicIO.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "resource.h"
#include "OOPic.h"

#define MAX_LOADSTRING 100

// Global Variables:
HINSTANCE hInst;								// current instance
HWND hWnd;
TCHAR szTitle[MAX_LOADSTRING];								// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];								// The title bar text

OOPic* m_pOOP;

// Foward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	Form(HWND, UINT, WPARAM, LPARAM);

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
 	// TODO: Place code here.
	MSG msg;
	HACCEL hAccelTable;

	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_OOPICIO, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	
	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_OOPICIO);


	// app stuff here

	// create oopic instance
	m_pOOP = new OOPic();
	
	// create dialog form
	HWND hDlg = CreateDialog(
		hInst,					 // handle to module
		(LPCTSTR)IDD_FORMVIEW,   // dialog box template name
		hWnd,                    // handle to owner window
		(DLGPROC)Form            // dialog box procedure
	);

	if (!hDlg) return FALSE;

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
}



//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage is only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_OOPICIO);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPCSTR)IDC_OOPICIO;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx(&wcex);
}

//
//   FUNCTION: InitInstance(HANDLE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	hInst = hInstance; // Store instance handle in our global variable

	/*
	hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
	  CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);
	*/

	hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU,
	  CW_USEDEFAULT, 0, 283, 415, NULL, NULL, hInstance, NULL);

	if (!hWnd)
	{
	  return FALSE;
	}

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	return TRUE;
}

//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;

	switch (message) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{
				case IDM_ABOUT:
				   DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				   break;
				case IDM_EXIT:
				   DestroyWindow(hWnd);
				   break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_DESTROY:
			delete m_pOOP;
			PostQuitMessage(0);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

// Message handler for about box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
				return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

// Message handler for form
LRESULT CALLBACK Form(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent, addr, val;
	HWND hItem = NULL;
	BOOL success;

	switch (message)
	{
		case WM_INITDIALOG:
			SetDlgItemInt(hDlg, IDC_WADDR, 41, false );
			SetDlgItemInt(hDlg, IDC_WVAL, 50, false );
			SetDlgItemInt(hDlg, IDC_RADDR, 49, false );
			SetDlgItemText(hDlg, IDC_CODEEDIT, 
				"Dim rx as new oDDELink\x0D\x0A"
				"Dim tx as new oDDELink\x0D\x0A"
				"\x0D\x0A"
				"Dim S1 As New oServo\x0D\x0A"
				"\x0D\x0A"
				"Sub Main()\x0D\x0A"
				  "\x0D\x0A"
				  "OOPic.Node = 2\x0D\x0A"
				  "\x0D\x0A"
				  "S1.IOLine = 1\x0D\x0A"
				  "S1.Operate =cvTrue\x0D\x0A"
				  "S1 = 60\x0D\x0A"
				  "\x0D\x0A"				  
				  "rx.Direction=cvReceive\x0D\x0A"
				  "rx.Output.link(S1.Value)\x0D\x0A"
				  "rx.Operate = cvTrue\x0D\x0A"
				  "\x0D\x0A"
				  "tx.Direction=cvSend\x0D\x0A"
				  "tx.Input.link(S1.Value)\x0D\x0A"
				  "tx.Operate = cvTrue\x0D\x0A"
				  "\x0D\x0A"
				  "End Sub\x0D\x0A" );
			return TRUE;

		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			switch(wmId)
			{
			case IDC_BUTTONW:	// write value to oopic
				addr = GetDlgItemInt(hDlg,	   // handle to dialog box
									IDC_WADDR, // control identifier
									&success,  // success state
									false      // signed or unsigned value
									);
				if (!success) break;
				val = GetDlgItemInt(hDlg, IDC_WVAL, &success, false);
				if (!success) break;
				// write to address
				m_pOOP->Write(addr, val);
				break;
			case IDC_BUTTONR:	// read value from oopic
				addr = GetDlgItemInt(hDlg, IDC_RADDR, &success, false );
				if (!success) break;
				val = m_pOOP->ReadByte(addr);
				SetDlgItemInt(
						hDlg,       // handle to dialog box
						IDC_RVAL,	// control identifier
						val,		// value to set
						false		// signed or unsigned indicator
						);
				break;
			}
			return TRUE;
	}
    return FALSE;
}

