// OOPicNet.cpp: implementation of the OOPicNet class.
//
// code ported from the visual basic source code of the program 
// "I2CTools" and "ServoCtr" by OOPic.
// Alex Barth Dec. 2002
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "OOPicNet.h"
#include <stdio.h>


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

OOPicNet::OOPicNet()
{
	m_pI2CBus = new I2CBus();
}

OOPicNet::~OOPicNet()
{
	delete m_pI2CBus;
}

// writes memory to OOPic
//
bool OOPicNet::WriteMemoryToOOPic(BYTE bOOPicNode, BYTE bAddress, CHAR* chWriteBuffer, BYTE zWriteMask, BOOL bDDELinkRequest)
{
	BYTE EEPROMAck;
	TCHAR errstring[2048];

	// Send an I2C network start.
	if ( !m_pI2CBus->I2CSendStart() )
	{
		m_pI2CBus->I2CGetLastMessage(errstring);
		OutputDebugString( errstring );
		m_pI2CBus->I2CSendStop();
		return false;
	}
	

	// Address the OOPic to write the address to write to
	m_pI2CBus->I2CSendAddressW(bOOPicNode, &EEPROMAck);

	if (EEPROMAck == CI2CNACK )
	{
		OutputDebugString("OOPicNet: The OOPic did not respond!\n");
		return false;
	}
	
	unsigned int i = 0;
	int j = 0;
	BYTE Ack = 0;
	BYTE bToSend;
	char c;
	char *sz = chWriteBuffer;

	if (bDDELinkRequest )
	{
		// Send the address of the DDELink Object to talk to.
		// For writing, the address must be adjusted by 129.
		m_pI2CBus->I2CSendByte(bAddress + 129);

		// Send the mask for the data to send.
		// For a DDELink Object, no mask is needed.
		m_pI2CBus->I2CSendByte(0);

		// Send the DDELink Buffer byte 0
		strncpy(&c, chWriteBuffer, 1);
		m_pI2CBus->I2CSendByte(c);

		// Send the DDELink Buffer byte 1
		m_pI2CBus->I2CSendByte(0);

		// Send a data ready bit
		m_pI2CBus->I2CSendByte(128);
	}
	else // !bDDELinkRequest
	{

		// Send the address to write data to.
		m_pI2CBus->I2CSendByte(bAddress ^ 128);

		// Send the mask for the data to send.
		// For a DDELink Object, no mask is needed.
		m_pI2CBus->I2CSendByte(zWriteMask);

		// send the chWriteBuffer bytes
		//
		i = 0;

		while (i < strlen(chWriteBuffer))
		{
			strncpy(&c, sz, 1);

			bToSend = c;

			m_pI2CBus->I2CSendByte(bToSend, &Ack);

			if (Ack != 0) // success
			{
				sz++;     // increase pointer to next char
				j = 0;
				i++;
			}
			else	// failed to send
			{
				    // if failed, try it 4 times more
				j++;
				if (j > 3) 
				{
					// abort
					m_pI2CBus->I2CSendStop();
					return false;
				}
			}
		}
	}

	// Done
	m_pI2CBus->I2CSendStop();

	return true;

}


// read from oopic memory
//
bool OOPicNet::ReadMemoryFromOOPic(BYTE bOOPicNode, BYTE bAddress, CHAR* chReadBuffer, BYTE bBytesToRead, BOOL bDDELinkRequest)
{
	BYTE EEPROMAck;
	TCHAR errstring[2048];
	
	if (bBytesToRead == 0) return false;

	// Send an I2C network start.
	if ( !m_pI2CBus->I2CSendStart() )
	{
		m_pI2CBus->I2CGetLastMessage(errstring);
		OutputDebugString( errstring);
		m_pI2CBus->I2CSendStop();
		return false;
	}

	// Address the OOPic to write the address to read from
	m_pI2CBus->I2CSendAddressW(bOOPicNode, &EEPROMAck);

	if (EEPROMAck == CI2CNACK )
	{
		OutputDebugString("OOPicNet: OOPic did not Respond!\n");
		m_pI2CBus->I2CSendStop();
		return false;
	}

	// Send the address to read, must be adjusted by 128.
	m_pI2CBus->I2CSendByte(bAddress + 128);

	if ( bDDELinkRequest)
	{
		// Send the mask for the data to send.
		// For the DDELink data request bit, its 127
		m_pI2CBus->I2CSendByte(127);

		// Send the DDELink data request bit
		m_pI2CBus->I2CSendByte(128);
	}

	// Send an I2C network start.
	if ( !m_pI2CBus->I2CSendStart() )
	{
		m_pI2CBus->I2CGetLastMessage(errstring);
		OutputDebugString( errstring );
		m_pI2CBus->I2CSendStop();
		return false;
	}

	// Address the OOPic to read from it
	m_pI2CBus->I2CSendAddressR(bOOPicNode, &EEPROMAck);

	if (EEPROMAck == CI2CNACK )
	{
		OutputDebugString("OOPicNet: OOPic did not Respond!\n");
		m_pI2CBus->I2CSendStop();
		return false;
	}

	char c;

	sprintf(chReadBuffer, "");

	// read the memory
	for ( int i = 0; i<(bBytesToRead-1); i++)
	{
		c = m_pI2CBus->I2CReadByte();
		sprintf(chReadBuffer, "%s%c", chReadBuffer, c);  // ??
		m_pI2CBus->I2CSendAck();
	}

	c = m_pI2CBus->I2CReadByte();
	sprintf(chReadBuffer, "%s%c", chReadBuffer, c);    // ??
	m_pI2CBus->I2CSendNAck();

	// Done
	m_pI2CBus->I2CSendStop();

	return true;

}